## Fakturio – stručný návod pro uživatele

### 1. Instalace

1. Rozbalte stažený balíček (ZIP / DMG).
2. Přetáhněte `Fakturio.app` do složky **Aplikace** (Applications) nebo do libovolné vlastní složky.
3. Spusťte aplikaci:
   - dvojklikem, nebo
   - přes `open "Fakturio.app"` v Terminálu.
4. Protože aplikace není podepsaná Apple Developer ID, může macOS zobrazit varování:
   - nejjednodušší cesta: klikněte **pravým tlačítkem** na `Fakturio.app` → **Otevřít** → znovu **Otevřít** v dialogu,
   - pokročilá varianta: v Terminálu můžete odstranit příznak „staženo z internetu“:

     ```bash
     xattr -dr com.apple.quarantine "/cesta/k/Fakturio.app"
     ```

     (nejjednodušší je napsat začátek příkazu `xattr -dr com.apple.quarantine `, pak do Terminálu přetáhnout ikonu aplikace z Finderu a stisknout Enter).

### 2. První nastavení

1. Otevřete sekci **Firmy** v levém menu.
2. Založte svou firmu:
   - vyplňte název, IČ, DIČ (klidně s „CZ“), adresu, město, PSČ,
   - doplňte bankovní účet (ideálně ve formátu IBAN nebo „číslo/ kód banky“).
3. Uložte firmu – bude se používat jako vystavitel faktur a plátce DPH.

### 3. Klienti (odběratelé)

1. V sekci **Klienti** založte odběratele:
   - název / jméno,
   - IČ, DIČ (může být s „CZ“),
   - adresu, město, PSČ.
2. Klienti se pak vybírají při vystavování faktury z rozbalovacího seznamu.

### 4. Vystavení faktury (vydaná faktura)

1. Přejděte do **Faktury vydané**.
2. Klikněte na **„Nová faktura“**.
3. Vyplňte:
   - **Číslo faktury** (může se doplnit automaticky),
   - **Klienta**,
   - **Datum vystavení**, **datum zdanitelného plnění**, **datum splatnosti**,
   - volitelně variabilní a konstantní symbol, způsob platby.
4. Přidejte položky:
   - název, množství, jednotku, cenu bez DPH, sazbu DPH (typicky 21 %),
   - souhrn se přepočte automaticky.
5. Uložte fakturu tlačítkem **„Uložit fakturu“**.

### 5. Generování PDF faktury

1. V seznamu faktur klikněte na konkrétní fakturu.
2. Otevře se **detail faktury**.
3. Klikněte na tlačítko **„Generovat PDF“**.
4. Zobrazí se dialog pro uložení:
   - vyberte složku,
   - potvrďte název souboru,
   - uložte.
5. Po úspěšném uložení se zobrazí potvrzení v aplikaci.

> Variabilní symbol:  
> Pokud není u faktury zadán, systém automaticky použije číslo faktury (včetně v QR kódu).

### 6. Přijaté faktury (odpočet DPH)

1. Přejděte do **Faktury přijaté**.
2. Přidejte přijaté doklady:
   - dodavatele (název, DIČ),
   - číslo dokladu,
   - datum vystavení a datum zdanitelného plnění,
   - částky bez DPH, DPH a celkem,
   - volitelnou poznámku (např. „telefon“, „palivo“, „software“).
3. Tyto doklady se používají pro výpočet **nároku na odpočet DPH**.

### 7. Reporty, DPH a Kontrolní hlášení

1. Přejděte do sekce **Reporty**.
2. Nahoře zvolte:
   - **Režim** – měsíční nebo čtvrtletní,
   - **Rok**,
   - **Měsíc** nebo **čtvrtletí** podle zvoleného režimu.
3. Klikněte na **„Načíst“** – zobrazí se přehled a statistiky.
4. Exporty:
   - **„Kontrolní hlášení (XML)”** – vygeneruje soubor KH pro vybrané období,
   - **„Přiznání k DPH (XML)”** – vygeneruje soubor DPH pro vybrané období.
5. Po exportu se zobrazí hláška o úspěšném uložení.

> Limit 10 000 Kč v kontrolním hlášení:  
> Faktury s celkovou částkou **≥ 10 000 Kč včetně DPH** jsou uvedeny v KH jednotlivě.  
> Faktury **pod 10 000 Kč včetně DPH** se v KH projeví jen v souhrnných částkách.

### 8. DPH a KH do EPO

1. Vygenerované XML soubory (DPH i KH) můžete nahrát v systému **EPO/ADIS**:
   - otevřete formulář pro DPH nebo Kontrolní hlášení,
   - zvolte možnost **„Načíst z XML“**,
   - vyberte soubor vygenerovaný aplikací.
2. Zkontrolujte vyplněné hodnoty a případně je upravte / doplňte.

### 9. DEMO verze (pokud používáte)

- DEMO verze je omezená na **maximálně 10 vydaných faktur**.
- Při pokusu o vytvoření další faktury se zobrazí informace o limitu a doporučení přejít na plnou verzi.

### 10. Upozornění

- Aplikace je pomocný nástroj pro práci s fakturami a DPH.
- **Není to daňové poradenství** – za správnost podaného přiznání a kontrolního hlášení odpovídá vždy uživatel.
- Před prvním používáním v „ostrém provozu“ doporučujeme:
  - ověřit prvních několik podání s účetním nebo daňovým poradcem,
  - otestovat exporty na testovacích datech.

### 11. Plná verze a licence

- DEMO verze je omezená jen počtem vydaných faktur (viz výše).  
- Plnou verzi aktivuješ tak, že v **Nastavení → Licence** vložíš licenční kód, který dostaneš e‑mailem po zaplacení.  
- Standardně jde o **roční licenci** (pro jedno IČO nebo pro účetní s více klienty); pokud nechceš řešit obnovování, můžeš se domluvit i na jednorázové „doživotní“ licenci.
- Licenční kód v sobě nese i **datum konce platnosti** (např. `2026-03-31`) a aplikace podle něj pozná, jestli je licence ještě platná nebo už vypršela – po vypršení můžeš kdykoliv zadat nový kód.

